"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.initForElectronMain = void 0;
var node_addon_shared_lib_loader_1 = require("@wontok/node-addon-shared-lib-loader");
var process_scanning_native_api_1 = require("./process-scanning-native-api");
var commands_1 = require("./commands");
var config_1 = __importDefault(require("./config"));
var utils_1 = require("./utils");
var currentState = null;
//#region Event Triggers
var notifyAllWindowsOfLatestState = function (publicOptions) {
    if (currentState != null) {
        publicOptions.onStateChange(currentState);
        // 3. I'm not sending any process scanning information to the renderer.
        // webContents.getAllWebContents().forEach((webContent) => {
        //   webContent.send(Channels.processScanningOnStateChange, currentState);
        // });
    }
};
var notifyAllWindowsOfBlockedContent = function (publicOptions, blockedContentInfo) {
    publicOptions.onBlockedContent(blockedContentInfo);
    // 3. I'm not sending any process scanning information to the renderer.
    // webContents.getAllWebContents().forEach((webContent) => {
    //   webContent.send(
    //     Channels.processScanningOnBlockedContent,
    //     blockedContentInfo
    //   );
    // });
};
//#endregion
var initForElectronMain = function (publicOptions) {
    var initOptions = {
        currentTimestamp: Math.floor(new Date().getTime() / 1000),
        processScanningServiceBinariesDirectory: config_1.default.processScanningServiceBinariesDirectory,
    };
    var onStateChangeCallback = function (event) {
        var state = {
            isScanning: event.payload.isScanning,
            nativeServiceAvailable: event.payload.nativeServiceAvailable,
        };
        currentState = state;
        utils_1.debug("Got new state in public Electron Land: " + JSON.stringify(state) + "\n");
        notifyAllWindowsOfLatestState(publicOptions);
    };
    onStateChangeCallback.callbackName = process_scanning_native_api_1.CallbackNames.onStateChange;
    var onBlockedContentCallback = function (event) {
        var blockedContentInfo = {
            description: event.payload.description,
            reason: event.payload.reason,
        };
        utils_1.debug("Got blocked content in public Electron Land: " + JSON.stringify(blockedContentInfo) + "\n");
        notifyAllWindowsOfBlockedContent(publicOptions, blockedContentInfo);
    };
    onBlockedContentCallback.callbackName = process_scanning_native_api_1.CallbackNames.onBlockedContent;
    var sharedLibController = node_addon_shared_lib_loader_1.initSharedLib(config_1.default.sharedLib, initOptions, [
        onStateChangeCallback,
        onBlockedContentCallback,
    ]);
    // 3. I'm not sending any process scanning information to the renderer.
    // ipcMain.on(Channels.processScanningOnRendererInit, () => {
    //   notifyAllWindowsOfLatestState(publicOptions);
    // });
    // ipcMain.on(Channels.processScanningCommand, (_, command) => {
    //   sharedLibController.executeCommands([command]);
    // });
    return {
        activateNativeService: function () {
            return sharedLibController.executeCommands([commands_1.commandActivateNativeService()]);
        },
        setLicenseExpirationDate: function (when) {
            return sharedLibController.executeCommands([
                commands_1.commandSetLicenseExpirationTimestamp(when),
            ]);
        },
        startScanning: function () {
            return sharedLibController.executeCommands([commands_1.commandStartScanning()]);
        },
        stopScanning: function () {
            return sharedLibController.executeCommands([commands_1.commandStopScanning()]);
        },
        unload: sharedLibController.unload,
    };
};
exports.initForElectronMain = initForElectronMain;
